/// <summary>
/// Nutty Software Open WebGL Framework
/// 
/// Copyright (C) 2012 Nathaniel Meyer
/// Nutty Software, http://www.nutty.ca
/// All Rights Reserved.
/// 
/// Permission is hereby granted, free of charge, to any person obtaining a copy of
/// this software and associated documentation files (the "Software"), to deal in
/// the Software without restriction, including without limitation the rights to
/// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
/// of the Software, and to permit persons to whom the Software is furnished to do
/// so, subject to the following conditions:
///     1. The above copyright notice and this permission notice shall be included in all
///        copies or substantial portions of the Software.
///     2. Redistributions in binary or minimized form must reproduce the above copyright
///        notice and this list of conditions in the documentation and/or other materials
///        provided with the distribution.
/// 
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.
/// </summary>


/// <summary>
/// This shader renders an old image effect using a combination of sepia toning,
/// noise, scratching, and vignetting.
/// </summary>


/// <summary>
/// Constructor.
/// </summary>
function OldFilmShader ()
{
	/// <summary>
	/// Setup inherited members.
	/// </summary>
	ImageShader.call(this);
	

	/// <summary>
	/// Fragment Shader Variables.
	/// </summary>
	this.mSepiaValueId;
	this.mNoiseValueId;
	this.mScratchValueId;
	this.mInnerVignettingId;
	this.mOuterVignettingId;
	this.mRandomValueId;
	this.mTimeLapseValueId;
	
	
	/// <summary>
	/// Gets or sets the percentage of the sepia to apply.
	/// Valid range: 0.0 - 1.0.
	/// </summary>
	this.SepiaValue = 0.0;
	
	
	/// <summary>
	/// Gets or sets the percentage of the noise to apply.
	/// Valid range: 0.0 - 1.0.
	/// </summary>
	this.NoiseValue = 0.0;
	
	
	/// <summary>
	/// Gets or sets the percentage of scratching to apply.
	/// Valid range: 0.0 - 1.0.
	/// </summary>
	this.ScratchValue = 0.3;
	
	
	/// <summary>
	/// Gets or sets the amount of vignetting to apply.
	/// Valid range: 0.0 - 1.0.
	/// </summary>
	this.VignettingValue = 0.3;
	
	
	/// <summary>
	/// Gets or sets a random value to prepare a noisy image.
	/// This should be changed every frame.
	/// </summary>
	this.RandomValue = 0.0;
	
	
	/// <summary>
	/// Gets or sets the time that has lapsed.
	/// This should be changed every frame.
	/// </summary>
	this.TimeLapse = 0.0;
}


/// <summary>
/// Prototypal Inheritance.
/// </summary>
OldFilmShader.prototype = new ImageShader();
OldFilmShader.prototype.constructor = OldFilmShader;


/// <summary>
/// Implementation.
/// </summary>
OldFilmShader.prototype.Init = function ()
{
	ImageShader.prototype.Init.call(this);

	// Get shader variables
	this.mSepiaValueId = this.GetVariable("SepiaValue");
	this.mNoiseValueId = this.GetVariable("NoiseValue");
	this.mScratchValueId = this.GetVariable("ScratchValue");
	this.mInnerVignettingId = this.GetVariable("InnerVignetting");
	this.mOuterVignettingId = this.GetVariable("OuterVignetting");
	this.mRandomValueId = this.GetVariable("RandomValue");
	this.mTimeLapseId = this.GetVariable("TimeLapse");
}


/// <summary>
/// Implementation.
/// </summary>
OldFilmShader.prototype.Draw = function (entity, numPoints, numIndices)
{
	// Set shader values
	this.SetVariable(this.mSepiaValueId, this.SepiaValue);
	this.SetVariable(this.mNoiseValueId, this.NoiseValue);
	this.SetVariable(this.mScratchValueId, this.ScratchValue);
	this.SetVariable(this.mInnerVignettingId, 1.0 - this.VignettingValue);
	this.SetVariable(this.mOuterVignettingId, 1.4 - this.VignettingValue);
	this.SetVariable(this.mRandomValueId, this.RandomValue);
	this.SetVariable(this.mTimeLapseId, this.TimeLapse);

	ImageShader.prototype.Draw.call(this, entity, numPoints, numIndices);
}